//
//  OnlineSealViewController.swift
//  Demo iOS
//
//  Created by Benoit Vasseur on 06/07/2022.
//

import UIKit

class OnlineSealViewController: BaseViewController {

    @IBOutlet weak var containerView: UIView!
    @IBOutlet weak var pinField: UITextField!
    @IBOutlet weak var pinView: UIView!

    @IBOutlet weak var dataField: UITextField!
    @IBOutlet weak var resultContainerView: UIView!
    @IBOutlet weak var sealTextView: UILabel!
    

    override func viewDidLoad() {
        super.viewDidLoad()

        self.title = "Online Seal"
        
        containerView.isHidden = true
        resultContainerView.isHidden = true
        
        startSealProcess()
    }
    
    func startSealProcess() {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.startOnlineSealGenerationProcess()
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.containerView.isHidden = false
                    let pinMode = InweboService.sharedInstance.getPinMode()
                    self.pinView.isHidden = pinMode == IW_PINMODE_NONE
                } else {
                    self.showErrorFor(code: result)
                    self.navigationController?.popViewController(animated: true)
                }
            }
        }
    }
    
    func finalizeSealProcess(pin: String, data: String) {
        DispatchQueue.global().async {
            let result = InweboService.sharedInstance.finalizeOnlineSealGenerationProcess(pin: pin, toSeal: data)
            DispatchQueue.main.async {
                if result == IW_ERR_OK {
                    self.sealTextView.text = InweboService.sharedInstance.getOnlineSealAnswser()
                    self.resultContainerView.isHidden = false
                } else {
                    self.showErrorFor(code: result)
                }
            }
        }
    }
    
    @IBAction func generateTouched(_ sender: Any) {
        let pinMode = InweboService.sharedInstance.getPinMode()
        let data = self.dataField.text ?? ""
        
        if pinMode == IW_PINMODE_NONE {
            finalizeSealProcess(pin: "", data: data)
        } else if (pinMode & IW_PINMODE_CURRENT) != 0 {
            finalizeSealProcess(pin: self.pinField.text ?? "", data: data)
        }
    }
    
    @IBAction func copyTouched(_ sender: Any) {
        UIPasteboard.general.string = sealTextView.text
    }
    
}
